<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Unit\Parse\Xml;

use Magento\Mray\Parse\Xml\XMLStringToAssocArray;
use PHPUnit\Framework\TestCase;

class XMLStringToAssocArrayTest extends TestCase
{
    /**
     * @var XMLStringToAssocArray
     */
    private $service;

    protected function setUp(): void
    {
        $this->service = new XMLStringToAssocArray();
    }

    /**
     * @param string $xmlContent
     * @param array $expectedDbSchemaArray
     * @dataProvider dbSchemaXmlProvider
     */
    public function testExecute(string $xmlContent, array $expectedDbSchemaArray): void
    {
        $dbSchemaArray = $this->service->execute($xmlContent);
        $this->assertEquals($expectedDbSchemaArray, $dbSchemaArray);
    }

    /**
     * @return array[]
     */
    public function dbSchemaXmlProvider(): array
    {
        return [
            [
                file_get_contents(__DIR__ . '/_files/db_schema.xml'),
                include __DIR__ . '/_files/db_schema_array.php'
            ],
        ];
    }
}
