<?php return [
    'catalog_product_entity' =>
        [
            'name' => 'catalog_product_entity',
            'resource' => 'default',
            'engine' => 'innodb',
            'comment' => 'Catalog Product Table',
            'column' =>
                [
                    'entity_id' =>
                        [
                            'name' => 'entity_id',
                            'unsigned' => 'true',
                            'nullable' => 'false',
                            'identity' => 'true',
                            'comment' => 'Entity ID',
                            'type' => 'int'
                        ],
                    'attribute_set_id' =>
                        [
                            'name' => 'attribute_set_id',
                            'unsigned' => 'true',
                            'nullable' => 'false',
                            'identity' => 'false',
                            'default' => '0',
                            'comment' => 'Attribute Set ID',
                            'type' => 'smallint'
                        ],
                    'type_id' =>
                        [
                            'name' => 'type_id',
                            'nullable' => 'false',
                            'length' => '32',
                            'default' => 'simple',
                            'comment' => 'Type ID',
                            'type' => 'varchar'
                        ],
                    'sku' =>
                        [
                            'name' => 'sku',
                            'nullable' => 'false',
                            'length' => '64',
                            'comment' => 'SKU',
                            'type' => 'varchar'
                        ],
                    'has_options' =>
                        [
                            'name' => 'has_options',
                            'unsigned' => 'false',
                            'nullable' => 'false',
                            'identity' => 'false',
                            'default' => '0',
                            'comment' => 'Has Options',
                            'type' => 'smallint'
                        ],
                    'required_options' =>
                        [
                            'name' => 'required_options',
                            'unsigned' => 'true',
                            'nullable' => 'false',
                            'identity' => 'false',
                            'default' => '0',
                            'comment' => 'Required Options',
                            'type' => 'smallint'
                        ],
                    'created_at' =>
                        [
                            'name' => 'created_at',
                            'on_update' => 'false',
                            'nullable' => 'false',
                            'default' => 'CURRENT_TIMESTAMP',
                            'comment' => 'Creation Time',
                            'type' => 'timestamp'
                        ],
                    'updated_at' =>
                        [
                            'name' => 'updated_at',
                            'on_update' => 'true',
                            'nullable' => 'false',
                            'default' => 'CURRENT_TIMESTAMP',
                            'comment' => 'Update Time',
                            'type' => 'timestamp'
                        ],
                ],
            'constraint' =>
                [
                    'PRIMARY' =>
                        [
                            'referenceId' => 'PRIMARY',
                            'column' =>
                                [
                                    'entity_id' =>
                                        [
                                            'name' => 'entity_id',
                                        ],
                                ],
                            'type' => 'primary'
                        ],
                ],
            'index' =>
                [
                    'CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID' =>
                        [
                            'referenceId' => 'CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID',
                            'indexType' => 'btree',
                            'column' =>
                                [
                                    'attribute_set_id' =>
                                        [
                                            'name' => 'attribute_set_id',
                                        ],
                                ],
                        ],
                    'CATALOG_PRODUCT_ENTITY_SKU' =>
                        [
                            'referenceId' => 'CATALOG_PRODUCT_ENTITY_SKU',
                            'indexType' => 'btree',
                            'column' =>
                                [
                                    'sku' =>
                                        [
                                            'name' => 'sku',
                                        ],
                                ],
                        ],
                ],
        ],
    'catalog_product_entity_datetime' =>
        [
            'name' => 'catalog_product_entity_datetime',
            'resource' => 'default',
            'engine' => 'innodb',
            'comment' => 'Catalog Product Datetime Attribute Backend Table',
            'column' =>
                [
                    'value_id' =>
                        [
                            'name' => 'value_id',
                            'unsigned' => 'false',
                            'nullable' => 'false',
                            'identity' => 'true',
                            'comment' => 'Value ID',
                            'type' => 'int'
                        ],
                    'attribute_id' =>
                        [
                            'name' => 'attribute_id',
                            'unsigned' => 'true',
                            'nullable' => 'false',
                            'identity' => 'false',
                            'default' => '0',
                            'comment' => 'Attribute ID',
                            'type' => 'smallint'
                        ],
                    'store_id' =>
                        [
                            'name' => 'store_id',
                            'unsigned' => 'true',
                            'nullable' => 'false',
                            'identity' => 'false',
                            'default' => '0',
                            'comment' => 'Store ID',
                            'type' => 'smallint'
                        ],
                    'entity_id' =>
                        [
                            'name' => 'entity_id',
                            'unsigned' => 'true',
                            'nullable' => 'false',
                            'identity' => 'false',
                            'default' => '0',
                            'comment' => 'Entity ID',
                            'type' => 'int'
                        ],
                    'value' =>
                        [
                            'name' => 'value',
                            'on_update' => 'false',
                            'nullable' => 'true',
                            'comment' => 'Value',
                            'type' => 'datetime'
                        ],
                ],
            'constraint' =>
                [
                    'PRIMARY' =>
                        [
                            'referenceId' => 'PRIMARY',
                            'column' =>
                                [
                                    'value_id' =>
                                        [
                                            'name' => 'value_id',
                                        ],
                                ],
                            'type' => 'primary'
                        ],
                    'CAT_PRD_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID' =>
                        [
                            'referenceId' => 'CAT_PRD_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID',
                            'table' => 'catalog_product_entity_datetime',
                            'column' => 'attribute_id',
                            'referenceTable' => 'eav_attribute',
                            'referenceColumn' => 'attribute_id',
                            'onDelete' => 'CASCADE',
                            'type' => 'foreign'
                        ],
                    'CAT_PRD_ENTT_DTIME_ENTT_ID_CAT_PRD_ENTT_ENTT_ID' =>
                        [
                            'referenceId' => 'CAT_PRD_ENTT_DTIME_ENTT_ID_CAT_PRD_ENTT_ENTT_ID',
                            'table' => 'catalog_product_entity_datetime',
                            'column' => 'entity_id',
                            'referenceTable' => 'catalog_product_entity',
                            'referenceColumn' => 'entity_id',
                            'onDelete' => 'CASCADE',
                            'type' => 'foreign'
                        ],
                    'CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID' =>
                        [
                            'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID',
                            'table' => 'catalog_product_entity_datetime',
                            'column' => 'store_id',
                            'referenceTable' => 'store',
                            'referenceColumn' => 'store_id',
                            'onDelete' => 'CASCADE',
                            'type' => 'foreign'
                        ],
                    'CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID' =>
                        [
                            'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID',
                            'column' =>
                                [
                                    'entity_id' =>
                                        [
                                            'name' => 'entity_id',
                                        ],
                                    'attribute_id' =>
                                        [
                                            'name' => 'attribute_id',
                                        ],
                                    'store_id' =>
                                        [
                                            'name' => 'store_id',
                                        ],
                                ],
                            'type' => 'unique'
                        ],
                ],
            'index' =>
                [
                    'CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID' =>
                        [
                            'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID',
                            'indexType' => 'btree',
                            'column' =>
                                [
                                    'attribute_id' =>
                                        [
                                            'name' => 'attribute_id',
                                        ],
                                ],
                        ],
                    'CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID' =>
                        [
                            'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID',
                            'indexType' => 'btree',
                            'column' =>
                                [
                                    'store_id' =>
                                        [
                                            'name' => 'store_id',
                                        ],
                                ],
                        ],
                ],
        ],
    'custom_table_name' => [
        'name' => 'custom_table_name',
        'resource' => 'default',
        'engine' => 'innodb',
        'comment' => 'Custom Table',
        'column' =>
            [
                'id' =>
                    [
                        'type' => 'int',
                        'name' => 'id',
                        'unsigned' => 'false',
                        'nullable' => 'false',
                        'identity' => 'true',
                        'comment' => 'Value ID',
                    ],
                'attribute_id' =>
                    [
                        'type' => 'smallint',
                        'name' => 'attribute_id',
                        'unsigned' => 'true',
                        'nullable' => 'false',
                        'identity' => 'false',
                        'default' => '0',
                        'comment' => 'Attribute ID',
                    ],
                'store_id' =>
                    [
                        'type' => 'smallint',
                        'name' => 'store_id',
                        'unsigned' => 'true',
                        'nullable' => 'false',
                        'identity' => 'false',
                        'default' => '0',
                        'comment' => 'Store ID',
                    ],
                'entity_id' =>
                    [
                        'type' => 'int',
                        'name' => 'entity_id',
                        'unsigned' => 'true',
                        'nullable' => 'false',
                        'identity' => 'false',
                        'default' => '0',
                        'comment' => 'Entity ID',
                    ],
                'value' =>
                    [
                        'type' => 'datetime',
                        'name' => 'value',
                        'on_update' => 'false',
                        'nullable' => 'true',
                        'comment' => 'Value',
                    ],
            ],
        'constraint' =>
            [
                'CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID' =>
                    [
                        'type' => 'unique',
                        'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID',
                        'column' =>
                            [
                                'entity_id' =>
                                    [
                                        'name' => 'entity_id',
                                    ],
                                'attribute_id' =>
                                    [
                                        'name' => 'attribute_id',
                                    ],
                                'store_id' =>
                                    [
                                        'name' => 'store_id',
                                    ],
                            ],
                    ],
            ],
        'index' =>
            [
                'CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID' =>
                    [
                        'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID',
                        'indexType' => 'btree',
                        'column' =>
                            [
                                'attribute_id' =>
                                    [
                                        'name' => 'attribute_id',
                                    ],
                            ],
                    ],
                'CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID' =>
                    [
                        'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID',
                        'indexType' => 'btree',
                        'column' =>
                            [
                                'store_id' =>
                                    [
                                        'name' => 'store_id',
                                    ],
                            ],
                    ],
            ],
    ]
];
