<?php


use Magento\Mray\CodeStructuralElement\Php\Usage\UsageCase;

return [
    'catalog_product_entity' =>
        new UsageCase(
            'catalog_product_entity',
            'extended-core-table',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 10,
                            'endLine' => 10,
                        ],
                ],

                [
                    'name' => 'catalog_product_entity',
                    'resource' => 'default',
                    'engine' => 'innodb',
                    'comment' => 'Catalog Product Table',
                    'column' =>
                        [
                            'entity_id' =>
                                [
                                    'type' => 'int',
                                    'name' => 'entity_id',
                                    'unsigned' => 'true',
                                    'nullable' => 'false',
                                    'identity' => 'true',
                                    'comment' => 'Entity ID',
                                ],
                            'attribute_set_id' =>
                                [
                                    'type' => 'smallint',
                                    'name' => 'attribute_set_id',
                                    'unsigned' => 'true',
                                    'nullable' => 'false',
                                    'identity' => 'false',
                                    'default' => '0',
                                    'comment' => 'Attribute Set ID',
                                ],
                            'type_id' =>
                                [
                                    'type' => 'varchar',
                                    'name' => 'type_id',
                                    'nullable' => 'false',
                                    'length' => '32',
                                    'default' => 'simple',
                                    'comment' => 'Type ID',
                                ],
                            'sku' =>
                                [
                                    'type' => 'varchar',
                                    'name' => 'sku',
                                    'nullable' => 'false',
                                    'length' => '64',
                                    'comment' => 'SKU',
                                ],
                            'has_options' =>
                                [
                                    'type' => 'smallint',
                                    'name' => 'has_options',
                                    'unsigned' => 'false',
                                    'nullable' => 'false',
                                    'identity' => 'false',
                                    'default' => '0',
                                    'comment' => 'Has Options',
                                ],
                            'required_options' =>
                                [
                                    'type' => 'smallint',
                                    'name' => 'required_options',
                                    'unsigned' => 'true',
                                    'nullable' => 'false',
                                    'identity' => 'false',
                                    'default' => '0',
                                    'comment' => 'Required Options',
                                ],
                            'created_at' =>
                                [
                                    'type' => 'timestamp',
                                    'name' => 'created_at',
                                    'on_update' => 'false',
                                    'nullable' => 'false',
                                    'default' => 'CURRENT_TIMESTAMP',
                                    'comment' => 'Creation Time',
                                ],
                            'updated_at' =>
                                [
                                    'type' => 'timestamp',
                                    'name' => 'updated_at',
                                    'on_update' => 'true',
                                    'nullable' => 'false',
                                    'default' => 'CURRENT_TIMESTAMP',
                                    'comment' => 'Update Time',
                                ],
                        ],
                    'constraint' =>
                        [
                            'PRIMARY' =>
                                [
                                    'type' => 'primary',
                                    'referenceId' => 'PRIMARY',
                                    'column' =>
                                        [
                                            'entity_id' =>
                                                [
                                                    'name' => 'entity_id',
                                                ],
                                        ],
                                ],
                        ],
                    'index' =>
                        [
                            'CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID' =>
                                [
                                    'referenceId' => 'CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID',
                                    'indexType' => 'btree',
                                    'column' =>
                                        [
                                            'attribute_set_id' =>
                                                [
                                                    'name' => 'attribute_set_id',
                                                ],
                                        ],
                                ],
                            'CATALOG_PRODUCT_ENTITY_SKU' =>
                                [
                                    'referenceId' => 'CATALOG_PRODUCT_ENTITY_SKU',
                                    'indexType' => 'btree',
                                    'column' =>
                                        [
                                            'sku' =>
                                                [
                                                    'name' => 'sku',
                                                ],
                                        ],
                                ],
                        ],
                ],
        ),
    'catalog_product_entity.entity_id' =>
        new UsageCase(
            'catalog_product_entity.entity_id',
            'extended-core-table-column',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 12,
                            'endLine' => 12,
                        ],
                ],

                [
                    'type' => 'int',
                    'name' => 'entity_id',
                    'unsigned' => 'true',
                    'nullable' => 'false',
                    'identity' => 'true',
                    'comment' => 'Entity ID',
                ],
        ),
    'catalog_product_entity.attribute_set_id' =>
        new UsageCase(
            'catalog_product_entity.attribute_set_id',
            'extended-core-table-column',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 14,
                            'endLine' => 14,
                        ],
                ],

                [
                    'type' => 'smallint',
                    'name' => 'attribute_set_id',
                    'unsigned' => 'true',
                    'nullable' => 'false',
                    'identity' => 'false',
                    'default' => '0',
                    'comment' => 'Attribute Set ID',
                ],
        ),
    'catalog_product_entity.type_id' =>
        new UsageCase(
            'catalog_product_entity.type_id',
            'extended-core-table-column',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 15,
                            'endLine' => 15,
                        ],
                ],

                [
                    'type' => 'varchar',
                    'name' => 'type_id',
                    'nullable' => 'false',
                    'length' => '32',
                    'default' => 'simple',
                    'comment' => 'Type ID',
                ],
        ),
    'catalog_product_entity.sku' =>
        new UsageCase(
            'catalog_product_entity.sku',
            'extended-core-table-column',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 16,
                            'endLine' => 16,
                        ],
                ],

                [
                    'type' => 'varchar',
                    'name' => 'sku',
                    'nullable' => 'false',
                    'length' => '64',
                    'comment' => 'SKU',
                ],
        ),
    'catalog_product_entity.has_options' =>
        new UsageCase(
            'catalog_product_entity.has_options',
            'extended-core-table-column',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 18,
                            'endLine' => 18,
                        ],
                ],

                [
                    'type' => 'smallint',
                    'name' => 'has_options',
                    'unsigned' => 'false',
                    'nullable' => 'false',
                    'identity' => 'false',
                    'default' => '0',
                    'comment' => 'Has Options',
                ],
        ),
    'catalog_product_entity.required_options' =>
        new UsageCase(
            'catalog_product_entity.required_options',
            'extended-core-table-column',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 20,
                            'endLine' => 20,
                        ],
                ],

                [
                    'type' => 'smallint',
                    'name' => 'required_options',
                    'unsigned' => 'true',
                    'nullable' => 'false',
                    'identity' => 'false',
                    'default' => '0',
                    'comment' => 'Required Options',
                ],
        ),
    'catalog_product_entity.created_at' =>
        new UsageCase(
            'catalog_product_entity.created_at',
            'extended-core-table-column',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 22,
                            'endLine' => 22,
                        ],
                ],

                [
                    'type' => 'timestamp',
                    'name' => 'created_at',
                    'on_update' => 'false',
                    'nullable' => 'false',
                    'default' => 'CURRENT_TIMESTAMP',
                    'comment' => 'Creation Time',
                ],
        ),
    'catalog_product_entity.updated_at' =>
        new UsageCase(
            'catalog_product_entity.updated_at',
            'extended-core-table-column',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 24,
                            'endLine' => 24,
                        ],
                ],

                [
                    'type' => 'timestamp',
                    'name' => 'updated_at',
                    'on_update' => 'true',
                    'nullable' => 'false',
                    'default' => 'CURRENT_TIMESTAMP',
                    'comment' => 'Update Time',
                ],
        ),
    'catalog_product_entity.CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID' =>
        new UsageCase(
            'catalog_product_entity.CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID',
            'extended-core-table-index',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 28,
                            'endLine' => 28,
                        ],
                ],

                [
                    'referenceId' => 'CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID',
                    'indexType' => 'btree',
                    'column' =>
                        [
                            'attribute_set_id' =>
                                [
                                    'name' => 'attribute_set_id',
                                ],
                        ],
                ],
        ),
    'catalog_product_entity.CATALOG_PRODUCT_ENTITY_SKU' =>
        new UsageCase(
            'catalog_product_entity.CATALOG_PRODUCT_ENTITY_SKU',
            'extended-core-table-index',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 31,
                            'endLine' => 31,
                        ],
                ],

                [
                    'referenceId' => 'CATALOG_PRODUCT_ENTITY_SKU',
                    'indexType' => 'btree',
                    'column' =>
                        [
                            'sku' =>
                                [
                                    'name' => 'sku',
                                ],
                        ],
                ],
        ),
    'catalog_product_entity.PRIMARY' =>
        new UsageCase(
            'catalog_product_entity.PRIMARY',
            'extended-core-table-constraint',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 25,
                            'endLine' => 25,
                        ],
                ],

                [
                    'type' => 'primary',
                    'referenceId' => 'PRIMARY',
                    'column' =>
                        [
                            'entity_id' =>
                                [
                                    'name' => 'entity_id',
                                ],
                        ],
                ],
        ),
    'catalog_product_entity_datetime.CAT_PRD_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID' =>
        new UsageCase(
            'catalog_product_entity_datetime.CAT_PRD_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID',
            'extended-core-table-constraint',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 51,
                            'endLine' => 51,
                        ],
                ],

                [
                    'type' => 'foreign',
                    'referenceId' => 'CAT_PRD_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID',
                    'table' => 'catalog_product_entity_datetime',
                    'column' => 'attribute_id',
                    'referenceTable' => 'eav_attribute',
                    'referenceColumn' => 'attribute_id',
                    'onDelete' => 'CASCADE',
                ],
        ),
    'catalog_product_entity_datetime.CAT_PRD_ENTT_DTIME_ENTT_ID_CAT_PRD_ENTT_ENTT_ID' =>
        new UsageCase(
            'catalog_product_entity_datetime.CAT_PRD_ENTT_DTIME_ENTT_ID_CAT_PRD_ENTT_ENTT_ID',
            'extended-core-table-constraint',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 54,
                            'endLine' => 54,
                        ],
                ],

                [
                    'type' => 'foreign',
                    'referenceId' => 'CAT_PRD_ENTT_DTIME_ENTT_ID_CAT_PRD_ENTT_ENTT_ID',
                    'table' => 'catalog_product_entity_datetime',
                    'column' => 'entity_id',
                    'referenceTable' => 'catalog_product_entity',
                    'referenceColumn' => 'entity_id',
                    'onDelete' => 'CASCADE',
                ],
        ),
    'catalog_product_entity_datetime.CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID' =>
        new UsageCase(
            'catalog_product_entity_datetime.CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID',
            'extended-core-table-constraint',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 57,
                            'endLine' => 57,
                        ],
                ],

                [
                    'type' => 'foreign',
                    'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID',
                    'table' => 'catalog_product_entity_datetime',
                    'column' => 'store_id',
                    'referenceTable' => 'store',
                    'referenceColumn' => 'store_id',
                    'onDelete' => 'CASCADE',
                ],
        ),
    'catalog_product_entity_datetime' =>
        new UsageCase(
            'catalog_product_entity_datetime',
            'extended-core-table',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 36,
                            'endLine' => 36,
                        ],
                ],

                [
                    'name' => 'catalog_product_entity_datetime',
                    'resource' => 'default',
                    'engine' => 'innodb',
                    'comment' => 'Catalog Product Datetime Attribute Backend Table',
                    'column' =>
                        [
                            'value_id' =>
                                [
                                    'type' => 'int',
                                    'name' => 'value_id',
                                    'unsigned' => 'false',
                                    'nullable' => 'false',
                                    'identity' => 'true',
                                    'comment' => 'Value ID',
                                ],
                            'attribute_id' =>
                                [
                                    'type' => 'smallint',
                                    'name' => 'attribute_id',
                                    'unsigned' => 'true',
                                    'nullable' => 'false',
                                    'identity' => 'false',
                                    'default' => '0',
                                    'comment' => 'Attribute ID',
                                ],
                            'store_id' =>
                                [
                                    'type' => 'smallint',
                                    'name' => 'store_id',
                                    'unsigned' => 'true',
                                    'nullable' => 'false',
                                    'identity' => 'false',
                                    'default' => '0',
                                    'comment' => 'Store ID',
                                ],
                            'entity_id' =>
                                [
                                    'type' => 'int',
                                    'name' => 'entity_id',
                                    'unsigned' => 'true',
                                    'nullable' => 'false',
                                    'identity' => 'false',
                                    'default' => '0',
                                    'comment' => 'Entity ID',
                                ],
                            'value' =>
                                [
                                    'type' => 'datetime',
                                    'name' => 'value',
                                    'on_update' => 'false',
                                    'nullable' => 'true',
                                    'comment' => 'Value',
                                ],
                        ],
                    'constraint' =>
                        [
                            'PRIMARY' =>
                                [
                                    'type' => 'primary',
                                    'referenceId' => 'PRIMARY',
                                    'column' =>
                                        [
                                            'value_id' =>
                                                [
                                                    'name' => 'value_id',
                                                ],
                                        ],
                                ],
                            'CAT_PRD_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID' =>
                                [
                                    'type' => 'foreign',
                                    'referenceId' => 'CAT_PRD_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID',
                                    'table' => 'catalog_product_entity_datetime',
                                    'column' => 'attribute_id',
                                    'referenceTable' => 'eav_attribute',
                                    'referenceColumn' => 'attribute_id',
                                    'onDelete' => 'CASCADE',
                                ],
                            'CAT_PRD_ENTT_DTIME_ENTT_ID_CAT_PRD_ENTT_ENTT_ID' =>
                                [
                                    'type' => 'foreign',
                                    'referenceId' => 'CAT_PRD_ENTT_DTIME_ENTT_ID_CAT_PRD_ENTT_ENTT_ID',
                                    'table' => 'catalog_product_entity_datetime',
                                    'column' => 'entity_id',
                                    'referenceTable' => 'catalog_product_entity',
                                    'referenceColumn' => 'entity_id',
                                    'onDelete' => 'CASCADE',
                                ],
                            'CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID' =>
                                [
                                    'type' => 'foreign',
                                    'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID',
                                    'table' => 'catalog_product_entity_datetime',
                                    'column' => 'store_id',
                                    'referenceTable' => 'store',
                                    'referenceColumn' => 'store_id',
                                    'onDelete' => 'CASCADE',
                                ],
                            'CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID' =>
                                [
                                    'type' => 'unique',
                                    'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID',
                                    'column' =>
                                        [
                                            'entity_id' =>
                                                [
                                                    'name' => 'entity_id',
                                                ],
                                            'attribute_id' =>
                                                [
                                                    'name' => 'attribute_id',
                                                ],
                                            'store_id' =>
                                                [
                                                    'name' => 'store_id',
                                                ],
                                        ],
                                ],
                        ],
                    'index' =>
                        [
                            'CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID' =>
                                [
                                    'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID',
                                    'indexType' => 'btree',
                                    'column' =>
                                        [
                                            'attribute_id' =>
                                                [
                                                    'name' => 'attribute_id',
                                                ],
                                        ],
                                ],
                            'CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID' =>
                                [
                                    'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID',
                                    'indexType' => 'btree',
                                    'column' =>
                                        [
                                            'store_id' =>
                                                [
                                                    'name' => 'store_id',
                                                ],
                                        ],
                                ],
                        ],
                ],
        ),
    'catalog_product_entity_datetime.value_id' =>
        new UsageCase(
            'catalog_product_entity_datetime.value_id',
            'extended-core-table-column',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 38,
                            'endLine' => 38,
                        ],
                ],

                [
                    'type' => 'int',
                    'name' => 'value_id',
                    'unsigned' => 'false',
                    'nullable' => 'false',
                    'identity' => 'true',
                    'comment' => 'Value ID',
                ],
        ),
    'catalog_product_entity_datetime.attribute_id' =>
        new UsageCase(
            'catalog_product_entity_datetime.attribute_id',
            'extended-core-table-column',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 40,
                            'endLine' => 40,
                        ],
                ],

                [
                    'type' => 'smallint',
                    'name' => 'attribute_id',
                    'unsigned' => 'true',
                    'nullable' => 'false',
                    'identity' => 'false',
                    'default' => '0',
                    'comment' => 'Attribute ID',
                ],
        ),
    'catalog_product_entity_datetime.store_id' =>
        new UsageCase(
            'catalog_product_entity_datetime.store_id',
            'extended-core-table-column',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 42,
                            'endLine' => 42,
                        ],
                ],

                [
                    'type' => 'smallint',
                    'name' => 'store_id',
                    'unsigned' => 'true',
                    'nullable' => 'false',
                    'identity' => 'false',
                    'default' => '0',
                    'comment' => 'Store ID',
                ],
        ),
    'catalog_product_entity_datetime.entity_id' =>
        new UsageCase(
            'catalog_product_entity_datetime.entity_id',
            'extended-core-table-column',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 44,
                            'endLine' => 44,
                        ],
                ],

                [
                    'type' => 'int',
                    'name' => 'entity_id',
                    'unsigned' => 'true',
                    'nullable' => 'false',
                    'identity' => 'false',
                    'default' => '0',
                    'comment' => 'Entity ID',
                ],
        ),
    'catalog_product_entity_datetime.value' =>
        new UsageCase(
            'catalog_product_entity_datetime.value',
            'extended-core-table-column',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 45,
                            'endLine' => 45,
                        ],
                ],

                [
                    'type' => 'datetime',
                    'name' => 'value',
                    'on_update' => 'false',
                    'nullable' => 'true',
                    'comment' => 'Value',
                ],
        ),
    'catalog_product_entity_datetime.CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID' =>
        new UsageCase(
            'catalog_product_entity_datetime.CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID',
            'extended-core-table-index',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 63,
                            'endLine' => 63,
                        ],
                ],

                [
                    'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID',
                    'indexType' => 'btree',
                    'column' =>
                        [
                            'attribute_id' =>
                                [
                                    'name' => 'attribute_id',
                                ],
                        ],
                ],
        ),
    'catalog_product_entity_datetime.CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID' =>
        new UsageCase(
            'catalog_product_entity_datetime.CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID',
            'extended-core-table-index',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 66,
                            'endLine' => 66,
                        ],
                ],

                [
                    'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID',
                    'indexType' => 'btree',
                    'column' =>
                        [
                            'store_id' =>
                                [
                                    'name' => 'store_id',
                                ],
                        ],
                ],
        ),
    'catalog_product_entity_datetime.PRIMARY' =>
        new UsageCase(
            'catalog_product_entity_datetime.PRIMARY',
            'extended-core-table-constraint',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 46,
                            'endLine' => 46,
                        ],
                ],

                [
                    'type' => 'primary',
                    'referenceId' => 'PRIMARY',
                    'column' =>
                        [
                            'value_id' =>
                                [
                                    'name' => 'value_id',
                                ],
                        ],
                ],
        ),
    'catalog_product_entity_datetime.CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID' =>
        new UsageCase(
            'catalog_product_entity_datetime.CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID',
            'extended-core-table-constraint',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 58,
                            'endLine' => 58,
                        ],
                ],

                [
                    'type' => 'unique',
                    'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID',
                    'column' =>
                        [
                            'entity_id' =>
                                [
                                    'name' => 'entity_id',
                                ],
                            'attribute_id' =>
                                [
                                    'name' => 'attribute_id',
                                ],
                            'store_id' =>
                                [
                                    'name' => 'store_id',
                                ],
                        ],
                ],
        ),
    'custom_table_name' =>
        new UsageCase(
            'custom_table_name',
            'added-table',

                [
                    'file' => '/_files/db_schema.xml',
                    'position' =>
                        [
                            'startLine' => 71,
                            'endLine' => 71,
                        ],
                ],

                [
                    'name' => 'custom_table_name',
                    'resource' => 'default',
                    'engine' => 'innodb',
                    'comment' => 'Custom Table',
                    'column' =>
                        [
                            'id' =>
                                [
                                    'type' => 'int',
                                    'name' => 'id',
                                    'unsigned' => 'false',
                                    'nullable' => 'false',
                                    'identity' => 'true',
                                    'comment' => 'Value ID',
                                ],
                            'attribute_id' =>
                                [
                                    'type' => 'smallint',
                                    'name' => 'attribute_id',
                                    'unsigned' => 'true',
                                    'nullable' => 'false',
                                    'identity' => 'false',
                                    'default' => '0',
                                    'comment' => 'Attribute ID',
                                ],
                            'store_id' =>
                                [
                                    'type' => 'smallint',
                                    'name' => 'store_id',
                                    'unsigned' => 'true',
                                    'nullable' => 'false',
                                    'identity' => 'false',
                                    'default' => '0',
                                    'comment' => 'Store ID',
                                ],
                            'entity_id' =>
                                [
                                    'type' => 'int',
                                    'name' => 'entity_id',
                                    'unsigned' => 'true',
                                    'nullable' => 'false',
                                    'identity' => 'false',
                                    'default' => '0',
                                    'comment' => 'Entity ID',
                                ],
                            'value' =>
                                [
                                    'type' => 'datetime',
                                    'name' => 'value',
                                    'on_update' => 'false',
                                    'nullable' => 'true',
                                    'comment' => 'Value',
                                ],
                        ],
                    'constraint' =>
                        [
                            'CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID' =>
                                [
                                    'type' => 'unique',
                                    'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID',
                                    'column' =>
                                        [
                                            'entity_id' =>
                                                [
                                                    'name' => 'entity_id',
                                                ],
                                            'attribute_id' =>
                                                [
                                                    'name' => 'attribute_id',
                                                ],
                                            'store_id' =>
                                                [
                                                    'name' => 'store_id',
                                                ],
                                        ],
                                ],
                        ],
                    'index' =>
                        [
                            'CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID' =>
                                [
                                    'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID',
                                    'indexType' => 'btree',
                                    'column' =>
                                        [
                                            'attribute_id' =>
                                                [
                                                    'name' => 'attribute_id',
                                                ],
                                        ],
                                ],
                            'CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID' =>
                                [
                                    'referenceId' => 'CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID',
                                    'indexType' => 'btree',
                                    'column' =>
                                        [
                                            'store_id' =>
                                                [
                                                    'name' => 'store_id',
                                                ],
                                        ],
                                ],
                        ],
                ],
        ),
];
