# Base CI for MRay

## Goals

The focus for this CI is to provide the necessary pipelines to automate common repository tasks, keeping as aligned as 
possible with the Adobe Security policies. Things to take into account:

* Use clean Docker images     - [x]  
* Use Adobe repositories      - [x]
* Maintain passwords on Vault - [x]

Direct communication between GitHub and Corporate Jenkins is not possible, so we will configure a poll system that 
will check the PR requests and trigger the **Pull Requests test** job

## Defined Jobs

### Jenkinsfile.test

This job is focused in running the tests over the `main` branch. This is ad-hoc. 

### Jenkinsfile.check_PR

This Job is meant to be run into a multibranch pipeline in order to poll for changes and execute tests when something comes up. 
It is mandatory to configure Github with branch protection to bind the Github repo and the Jenkins job.

## Defined Dockerfiles

To keep the Jenkins server as standard as we can, instead of installing PHP and other necessary stuff, we will build and 
run the test suite with a Docker container, based on an image built with the Adobe base tools and libraries. 
The Dockerfile is `Dockerfile.jenkins_worker`

## Ugly details

The current way to request the corporate Github repository is using SSH. This is messy because the +*.ssh** folder 
must be on the Jenkins instance running user home directory. We managed that on the `composer install` stage, 
recovering the private key from Vault and saving it on the **jnknsprd** home user (`/apps/home/jnknsprd/.ssh/id_rsa`)

## Secrets needed

Here comes the list of secrets needed. All of them are stored on the Vault safe storage (https://vault.dev.or1.adobe.net/ui/vault/secrets/dx_iberian_lynx/list/sut/)

| secret         | fields        | description  | 
|----------------|---------------|--------------|
| x_iberian_lynx/sut/github_credentials | user, api_token | Here are the credentials for the github access. We use the generic user magesut |
| dx_iberian_lynx/sut/magesut_composer_credentials| key_public, key_private | Marketplace credentials for the generic user magesut |
| dx_iberian_lynx/sut/corp_git_credentials| username, token, private_key | These are the crendentials for the user magesut for working with the Corporate Github |

