<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Api\Data;

class CustomProjectIndexResult
{
    /**
     * @var string
     */
    private $version;

    /**
     * @var array
     */
    private $customizations;

    /**
     * @param string $version
     * @param array $customizations
     */
    public function __construct(
        string $version,
        array $customizations
    ) {
        $this->version = $version;
        $this->customizations = $customizations;
    }

    /**
     * @return string
     */
    public function getVersion(): ?string
    {
        return $this->version;
    }

    /**
     * @return array
     */
    public function getCustomizations(): array
    {
        return $this->customizations;
    }
}
