<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Api\Data;

use Magento\Mray\Index\Collection\DbSchema;
use Magento\Mray\Index\Collection\Dictionary;
use Magento\Mray\Index\Collection\MagentoApi;
use Magento\Mray\Index\Collection\MagentoComponents;
use Magento\Mray\Index\Collection\PhpCode;
use Magento\Mray\Index\Collection\VirtualTypes;

class MagentoReleaseIndexResult
{
    /**
     * @var string
     */
    private $version;

    /**
     * @var MagentoComponents
     */
    private $componentsIndex;

    /**
     * @var PhpCode
     */
    private $phpCodeIndex;

    /**
     * @var MagentoApi
     */

    private $apiIndex;

    /**
     * @var Dictionary
     */
    private $dictionary;

    /**
     * @var VirtualTypes
     */
    private $virtualTypes;

    /**
     * @var DbSchema
     */
    private $dbSchema;

    /**
     * @param string $version
     * @param MagentoComponents $components
     * @param MagentoApi $api
     * @param PhpCode $phpCode
     * @param Dictionary $dictionary
     * @param VirtualTypes $virtualTypes
     * @param DbSchema $dbSchema
     */
    public function __construct(
        string $version,
        MagentoComponents $components,
        MagentoApi $api,
        PhpCode $phpCode,
        Dictionary $dictionary,
        VirtualTypes $virtualTypes,
        DbSchema $dbSchema
    ) {
        $this->version = $version;
        $this->componentsIndex = $components;
        $this->apiIndex = $api;
        $this->phpCodeIndex = $phpCode;
        $this->dictionary = $dictionary;
        $this->virtualTypes = $virtualTypes;
        $this->dbSchema = $dbSchema;
    }

    /**
     * @return string
     */
    public function getVersion(): string
    {
        return $this->version;
    }

    /**
     * @return MagentoComponents
     */
    public function getComponents(): MagentoComponents
    {
        return $this->componentsIndex;
    }

    /**
     * @return MagentoApi
     */
    public function getApi(): MagentoApi
    {
        return $this->apiIndex;
    }

    /**
     * @return PhpCode
     */
    public function getPhpCode(): PhpCode
    {
        return $this->phpCodeIndex;
    }

    /**
     * @return Dictionary
     */
    public function getDictionary(): Dictionary
    {
        return $this->dictionary;
    }

    /**
     * @return VirtualTypes
     */
    public function getVirtualTypes(): VirtualTypes
    {
        return $this->virtualTypes;
    }

    /**
     * @return DbSchema
     */
    public function getDbSchema(): DbSchema
    {
        return $this->dbSchema;
    }
}
