<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php;

use Magento\Mray\CodeStructuralElement\Php\Reflection\ClassLikeDeclaration;
use Magento\Mray\CodeStructuralElement\Php\Reflection\PropertyDeclaration;
use Magento\Mray\CodeStructuralElement\FullQualifiedStructuralElementName;
use phpDocumentor\Reflection\Type;

class ClassLikeProperty extends ClassLikeMember
{
    /**
     * @var object
     */
    private $p;

    /**
     * @param ClassLikeDeclaration $cl
     * @param PropertyDeclaration $p
     */
    public function __construct(
        ClassLikeDeclaration $cl,
        PropertyDeclaration $p
    ) {
        parent::__construct($cl);
        $this->p = (object)[
            'name' => $p->getName(),
            'checksum' => $p->getImplementationChecksum(),
            'valueType' => $p->getType(),
            'isPrivate' => $p->isPrivate(),
            'isPublic' => $p->isPublic(),
            'isStatic' => $p->isStatic(),
        ];
    }

    /**
     * @param PhpFqsen\ClassLike $className
     * @return FullQualifiedStructuralElementName
     */
    public function createAlias(PhpFqsen\ClassLike $className): FullQualifiedStructuralElementName
    {
        return new PhpFqsen\ClassLikeProperty(
            $className->pretty(),
            $this->p->name
        );
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'Php_Property';
    }

    /**
     * @return bool
     */
    public function isPrivate(): bool
    {
        return $this->p->isPrivate;
    }

    /**
     * @return bool
     */
    public function isPublic(): bool
    {
        return $this->p->isPublic;
    }

    /**
     * @return bool
     */
    public function isStatic(): bool
    {
        return $this->p->isStatic;
    }

    /**
     * @return Type
     */
    public function getValueType(): Type
    {
        return $this->p->valueType;
    }

    /**
     * @return string|null
     */
    public function getChecksum(): ?string
    {
        return $this->p->checksum;
    }
}
