<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php;

use Magento\Mray\CodeStructuralElement\Php\Reflection\ClassLikeDeclaration;
use Magento\Mray\CodeStructuralElement\FullQualifiedStructuralElementName;

class Interface_ implements ClassLike
{
    /** @var object  */
    private $i;
    /** @var array  */
    private $attributes;

    /**
     * @param ClassLikeDeclaration\Interface_ $i
     * @param array $attributes
     */
    public function __construct(ClassLikeDeclaration\Interface_ $i, array $attributes = [])
    {
        $this->i = (object)[
            'namespacedName' => $i->getName(),
            'extends' => $i->getImplementationProviders(),
            'checksum' => $i->getImplementationChecksum(),
        ];
        $this->attributes = $attributes;
    }

    /**
     * @return FullQualifiedStructuralElementName|null
     */
    public function getFqsen(): ?FullQualifiedStructuralElementName
    {
        if (isset($this->i->namespacedName)) {
            return new PhpFqsen\ClassLike((string)$this->i->namespacedName);
        }
        return null;
    }

    /**
     * @return PhpFqsen\ClassLike[]
     */
    public function getExtendedInterfacesFqsen(): array
    {
        $fqsens = [];
        foreach ($this->i->extends as $extends) {
            $fqsens[] = new PhpFqsen\ClassLike((string)$extends);
        }
        return $fqsens;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'Php_Interface';
    }

    /**
     * @param string $attr
     * @param mixed $val
     */
    public function setAttribute(string $attr, $val): void
    {
        $this->attributes[$attr] = $val;
    }

    /**
     * @param string $attr
     * @param mixed $default
     * @return mixed|null
     */
    public function getAttribute(string $attr, $default = null)
    {
        return $this->attributes[$attr] ?? $default;
    }

    /**
     * @return array
     */
    public function getAttributes(): array
    {
        return $this->attributes;
    }

    /**
     * @return string|null
     */
    public function getChecksum(): ?string
    {
        return $this->i->checksum;
    }
}
