<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;
use PhpParser\Node\Expr;

/**
 * This class explicitly declare expressions that are not resolved
 * to explicitly distinguish from these which does not have implementation.
 * So this documents decision that at this moment
 * we do not resolve types for expressions returned by getSupportedExpressions method.
 */
class AlwaysMixed implements Resolver
{
    /**
     * @param Expr $expr
     * @return Type
     */
    public function resolve(Expr $expr): Type
    {
        return TypeFactory::get(Types\Mixed_::class);
    }
}
