<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;
use PhpParser\Node\Expr;
use TypeError;
use function get_class;
use function sprintf;

class Array_ implements Resolver
{
    /**
     * @param Expr $expr
     * @return Type
     */
    public function resolve(Expr $expr): Type
    {
        if (!$expr instanceof Expr\Array_) {
            throw new TypeError(sprintf('%s is not applicable for %s expression.', self::class, get_class($expr)));
        }

        if (!$expr->items) {
            return TypeFactory::get(Types\Array_::class);
        }

        $memorizedResolver = new Memorized();
        $itemsType = null;

        foreach ($expr->items as $item) {
            if ($item == null) { // possible in list with skipped elements e.g. [, $v] = list($a);
                $itemType = TypeFactory::get(Types\Null_::class);
            } else {
                $itemType = $memorizedResolver->resolve($item);
            }

            if (isset($itemsType) && (string)$itemsType !== (string)$itemType) {
                return TypeFactory::get(Types\Array_::class);
            }
            $itemsType = $itemType;
        }

        return TypeFactory::get(Types\Array_::class, $itemsType);
    }
}
