<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;
use PhpParser\Node\Expr;
use function array_unique;
use function array_values;

class BitwiseOperators implements Resolver
{
    /**
     * @var Memorized
     */
    private $memorized;

    /**
     * BitwiseOperators constructor.
     */
    public function __construct()
    {
        $this->memorized = new Memorized();
    }

    /**
     * @param Expr $expr
     * @return Type
     */
    public function resolve(Expr $expr): Type
    {
        $operandTypes = [];
        foreach ($expr->getSubNodeNames() as $operand) {
            $operandTypes[] = $this->memorized->resolve($expr->{$operand});
        }
        $operandTypes = array_values(array_unique($operandTypes));

        $operandIsString = false;
        $operandMayBeString = false;
        $operandIsNotString = false;
        foreach ($operandTypes as $operandType) {
            if ($operandType instanceof Types\String_) {
                $operandIsString = true;
            } elseif ($operandType instanceof Types\Mixed_) {
                $operandMayBeString = true;
            } else {
                $operandIsNotString = true;
            }
        }

        if ($operandIsNotString) {
            return TypeFactory::get(Types\Integer::class);
        }

        if ($operandIsString && !$operandMayBeString) {
            return TypeFactory::get(Types\String_::class);
        }

        return TypeFactory::get(Types\Compound::class, [
            TypeFactory::get(Types\Integer::class),
            TypeFactory::get(Types\String_::class),
        ]);
    }
}
