<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

use Magento\Mray\CodeStructuralElement\Php\Reflection\ConstantDeclaration;
use Magento\Mray\CodeStructuralElement\Php\Reflection\Type\ClassLikeMemberValueType as DeferredDecisionType;
use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;
use PhpParser\Node\Expr;
use TypeError;
use function get_class;
use function sprintf;

class ClassConstFetch implements Resolver, Contextual
{
    use StaticAccess;

    /**
     * @param Expr $expr
     * @return Type
     */
    public function resolve(Expr $expr): Type
    {
        if (!$expr instanceof Expr\ClassConstFetch) {
            throw new TypeError(sprintf('%s is not applicable for %s expression.', self::class, get_class($expr)));
        }

        if ($expr->name instanceof Expr) {
            return TypeFactory::get(Types\Mixed_::class);
        }

        $const = (string)$expr->name;
        if ($const === 'class') {
            return TypeFactory::get(Types\String_::class);
        }

        $class = $this->getAccessedClass($expr);
        if (!$class) {
            return TypeFactory::get(Types\Mixed_::class);
        }

        return new DeferredDecisionType(
            $this->getContext()->getGlobal()->getStructuralElementDeclarations(),
            $class,
            ConstantDeclaration::class,
            (string)$const
        );
    }
}
