<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;
use PhpParser\Node\Expr;
use TypeError;
use function get_class;
use function sprintf;

class Clone_ implements Resolver
{
    /** @var Memorized */
    private $memorized;

    /**
     * Clone_ constructor.
     */
    public function __construct()
    {
        $this->memorized = new Memorized();
    }

    /**
     * @param Expr $expr
     * @return Type
     */
    public function resolve(Expr $expr): Type
    {
        if (!$expr instanceof Expr\Clone_) {
            throw new TypeError(sprintf(
                '%s is applicable only for %s but %s given.',
                self::class,
                Expr\Clone_::class,
                get_class($expr)
            ));
        }

        $operandType = $this->memorized->resolve($expr->expr);
        switch (get_class($operandType)) {
            case Types\Array_::class:
            case Types\Boolean::class:
            case Types\ClassString::class:
            case Types\Float_::class:
            case Types\Integer::class:
            case Types\Null_::class:
            case Types\Resource_::class:
            case Types\Scalar::class:
            case Types\String_::class:
            case Types\Void_::class:
                // we can be sure that this is not an object so will generate PHP fatal error which may be handled
                return TypeFactory::get(Types\Null_::class);
            default:
                return $operandType;
        }
    }
}
