<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

use Magento\Mray\CodeStructuralElement\Php\Reflection;

trait Context
{
    /** @var Reflection\Context */
    private $context;

    /**
     * @param Reflection\Context $context
     */
    public function setContext(Reflection\Context $context): void
    {
        $this->context = $context;
    }

    /**
     * @return Reflection\Context
     */
    public function getContext(): Reflection\Context
    {
        if (!isset($this->context)) {
            $this->context = Reflection\Context\None::instance();
        }
        return $this->context;
    }
}
