<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

use phpDocumentor\Reflection\Type;
use PhpParser\Node\Expr;
use TypeError;
use function get_class;
use function sprintf;

class ExprPassThrough implements Resolver
{
    /** @var Memorized  */
    private $memorized;

    /**
     * ExprPassThrough constructor.
     */
    public function __construct()
    {
        $this->memorized = new Memorized();
    }

    /**
     * @param Expr $expr
     * @return Type
     */
    public function resolve(Expr $expr): Type
    {
        if (!isset($expr->expr)) {
            throw new TypeError(sprintf(
                '%s is not applicable for %s expression as "expr" sub-node is missed.',
                self::class,
                get_class($expr)
            ));
        }

        return $this->memorized->resolve($expr->expr);
    }
}
