<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

class Factory
{
    /**
     * @return static
     */
    public static function default(): self
    {
        static $instance;
        if (!isset($instance)) {
            $instance = new self(Ruleset::default());
        }

        return $instance;
    }

    /** @var Resolver[]  */
    private $resolversMap;

    /**
     * @param Ruleset $ruleset
     */
    public function __construct(Ruleset $ruleset)
    {
        $this->resolversMap = $ruleset->compile();
    }

    /**
     * @return Resolver
     */
    public function create(): Resolver
    {
        return new Composite($this->resolversMap);
    }
}
