<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;
use PhpParser\Node\Expr;
use TypeError;
use function get_class;
use function sprintf;

class MatchResolver implements Resolver
{
    /**
     * @param Expr $expr
     * @return Type
     */
    public function resolve(Expr $expr): Type
    {
        if (!$expr instanceof Expr\Match_) {
            throw new TypeError(sprintf('%s is not applicable for %s expression.', self::class, get_class($expr)));
        }

        $memorizedResolver = new Memorized();
        $itemsType = null;

        foreach ($expr->arms as $arm) {
            $itemType = $memorizedResolver->resolve($arm->body);

            if (isset($itemsType) && (string)$itemsType !== (string)$itemType) {
                return TypeFactory::get(Types\Mixed_::class);
            }
            $itemsType = $itemType;
        }

        return $itemsType;
    }
}
