<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

use phpDocumentor\Reflection\Type;
use PhpParser\Node\Expr;

class Memorizing implements Resolver
{
    public const NODE_RESOLVED_TYPE = 'runtimeType';

    /** @var Resolver  */
    private $resolver;

    /**
     * @param Resolver $resolver
     */
    public function __construct(Resolver $resolver)
    {
        $this->resolver = $resolver;
    }

    /**
     * @param Expr $expr
     * @return Type
     */
    public function resolve(Expr $expr): Type
    {
        if (!isset($expr->{self::NODE_RESOLVED_TYPE})) {
            $expr->{self::NODE_RESOLVED_TYPE} = $this->resolver->resolve($expr);
        }
        return $expr->{self::NODE_RESOLVED_TYPE};
    }
}
