<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;
use PhpParser\Node\Expr;
use TypeError;
use function get_class;
use function sprintf;

class PostCrementOperators implements Resolver
{
    /** @var Memorized  */
    private $memorized;

    /**
     * PostCrementOperators constructor.
     */
    public function __construct()
    {
        $this->memorized = new Memorized();
    }

    /**
     * @param Expr $expr
     * @return Type
     */
    public function resolve(Expr $expr): Type
    {
        if (!isset($expr->var)) {
            throw new TypeError(sprintf(
                '%s is not applicable for %s expression as "var" sub-node is missed.',
                self::class,
                get_class($expr)
            ));
        }

        $operandType = $this->memorized->resolve($expr->var);
        if ($operandType instanceof Types\Null_ && $expr instanceof Expr\PostInc) {
            return TypeFactory::get(Types\Integer::class);
        }

        if ($operandType instanceof Types\String_) {
            return TypeFactory::get(Types\Compound::class, [
                TypeFactory::get(Types\String_::class),
                TypeFactory::get(Types\Integer::class),
                TypeFactory::get(Types\Float_::class),
            ]);
        }

        return $operandType;
    }
}
