<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;
use PhpParser\Node\Expr;
use TypeError;
use function get_class;
use function sprintf;

class PropertyFetch implements Resolver, Contextual
{
    use Context;

    /** @var Memorized  */
    private $memorized;

    /**
     * PropertyFetch constructor.
     */
    public function __construct()
    {
        $this->memorized = new Memorized();
    }

    /**
     * @param Expr $expr
     * @return Type
     */
    public function resolve(Expr $expr): Type
    {
        if (!$expr instanceof Expr\PropertyFetch && !$expr instanceof Expr\NullsafePropertyFetch) {
            throw new TypeError(sprintf('%s is not applicable for %s expression.', self::class, get_class($expr)));
        }

        return $this->readTypeFromContext(new ValueAccessor\Expr($expr)) ?: TypeFactory::get(Types\Mixed_::class);
    }

    /**
     * @param ValueAccessor $accessor
     * @return Type|null
     */
    private function readTypeFromContext(ValueAccessor $accessor): ?Type
    {
        $type = null;
        $container = $this->getContext();
        foreach ($accessor->getPath() as $pointer) {
            $var = $container->getVariable($pointer->getName());
            $type = $var->getType();
            $container = $var->getInnerContainer();
        }
        return $type;
    }
}
