<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;
use PhpParser\Node\Expr;
use TypeError;
use function get_class;
use function sprintf;

class TernaryOperator implements Resolver
{
    /** @var Memorized  */
    private $memorized;

    /**
     * TernaryOperator constructor.
     */
    public function __construct()
    {
        $this->memorized = new Memorized();
    }

    /**
     * @param Expr $expr
     * @return Type
     */
    public function resolve(Expr $expr): Type
    {
        if (!$expr instanceof Expr\Ternary) {
            throw new TypeError(sprintf('%s is not applicable for %s expression.', self::class, get_class($expr)));
        }

        $ifType = isset($expr->if) ?
            $this->memorized->resolve($expr->if) :
            $this->memorized->resolve($expr->cond);
        $elseType = $this->memorized->resolve($expr->else);

        if ($ifType instanceof Types\Mixed_ || $elseType instanceof Types\Mixed_) {
            return TypeFactory::get(Types\Mixed_::class);
        }

        if ($ifType === $elseType) {
            return $ifType;
        }

        return TypeFactory::get(Types\Compound::class, [$ifType, $elseType]);
    }
}
