<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\NodeVisitor;

use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use PhpParser\NodeTraverser;
use PhpParser\NodeVisitorAbstract;
use PhpParser\Node;
use phpDocumentor\Reflection\Types;

class StatementNodeVisitor extends NodeVisitorAbstract
{
    /**
     * @var array
     */
    private $returns = [];

    /**
     * @return array
     */
    public function getReturns(): array
    {
        return $this->returns;
    }

    /**
     * @param Node $node
     * @return array|int
     */
    public function enterNode(Node $node)
    {
        if (!$node instanceof Node\Stmt) {
            return NodeTraverser::DONT_TRAVERSE_CURRENT_AND_CHILDREN;
        }
        if ($node instanceof Node\Stmt\Return_) {
            if ($node->expr === null) {
                $this->returns[] = TypeFactory::get(Types\Void_::class);
            } else {
                $this->returns[] = $node->expr->runtimeType ?? TypeFactory::get(Types\Mixed_::class);
            }
        }
        return null;
    }
}
