<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php;

use Magento\Mray\CodeStructuralElement\Php\Parser\Result;
use PhpParser\ErrorHandler\Collecting as CollectingErrorHandler;
use PhpParser\NodeTraverser;
use PhpParser\Parser as ActualParser;

class Parser
{
    /** @var ActualParser  */
    private $parser;
    /** @var NodeTraverser  */
    private $traverser;

    /**
     * @param ActualParser $parser
     * @param NodeTraverser $traverser
     */
    public function __construct(ActualParser $parser, NodeTraverser $traverser)
    {
        $this->parser = $parser;
        $this->traverser = $traverser;
    }

    /**
     * @param string $code
     * @return Result
     */
    public function parse(string $code): Result
    {
        $errorHandler = new CollectingErrorHandler();
        $statements = $this->parser->parse($code, $errorHandler);
        $postProcessedStatements = $statements ? $this->traverser->traverse($statements) : [];
        $errors = $errorHandler->getErrors();

        return new Result($postProcessedStatements, $errors);
    }
}
