<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Parser;

use Magento\Mray\CodeStructuralElement\Php\NodeVisitor\StructuralElementsReflector;
use Magento\Mray\CodeStructuralElement\Php\NodeVisitor\ContextSwitcher;
use Magento\Mray\CodeStructuralElement\Php\NodeVisitor\ExpressionRuntimeTypeResolver;
use Magento\Mray\CodeStructuralElement\Php\NodeVisitor\MagentoApiRecognition;
use Magento\Mray\CodeStructuralElement\Php\NodeVisitor\PhpDocAst;
use Magento\Mray\CodeStructuralElement\Php\NodeVisitor\VariableDeclarationReflector;
use Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver\Factory as TypeResolverFactory;
use Magento\Mray\CodeStructuralElement\Php\Parser;
use Magento\Mray\CodeStructuralElement\Php\Reflection\Context;
use PhpParser\Lexer\Emulative as EmulativeLexer;
use PhpParser\NodeTraverser;
use PhpParser\NodeVisitor\NameResolver;
use PhpParser\ParserFactory;

class Factory
{
    /**
     * @param Context\Pointer|null $context
     * @return Parser
     */
    public static function create(?Context\Pointer $context = null): Parser
    {
        // Create  parser instance preconfigured to catch all necessary information
        $lexer = new EmulativeLexer([
            'phpVersion' => '7.4',
            'usedAttributes' => [
                'comments', // capture comments
                'startLine', // capture node start line in file
                'endLine', // capture node end line in file
                'startFilePos', // capture position in file to convert to column in start line
                'endFilePos' // capture position in file to convert to column in end line
            ],
        ]);
        $parser = (new ParserFactory())->create(ParserFactory::ONLY_PHP7, $lexer);
        $context = $context ?? new Context\Pointer(new Context\Global_());

        // Add visitors to extend AST information
        $traverser = new NodeTraverser();
        $traverser->addVisitor(new NameResolver());
        $traverser->addVisitor(new PhpDocAst());
        $traverser->addVisitor(new ContextSwitcher($context));
        $traverser->addVisitor(new StructuralElementsReflector($context));
        $traverser->addVisitor(new VariableDeclarationReflector($context));
        $traverser->addVisitor(new ExpressionRuntimeTypeResolver(TypeResolverFactory::default()->create(), $context));
        $traverser->addVisitor(new MagentoApiRecognition()); // todo: decouple from Magento-specific solution

        return new Parser($parser, $traverser);
    }
}
