<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Parser;

use PHPStan\PhpDocParser\Ast;
use PHPStan\PhpDocParser\Parser\PhpDocParser as OriginalParser;
use PHPStan\PhpDocParser\Parser\TokenIterator;

class PhpDocParser extends OriginalParser
{
    /**
     * @param TokenIterator $tokens
     * @param string $tag
     * @return Ast\PhpDoc\PhpDocTagValueNode
     */
    public function parseTagValue(TokenIterator $tokens, string $tag): Ast\PhpDoc\PhpDocTagValueNode
    {
        if ($tag === '@xglobal') { // recognize @xglobal as var declaration
            $tag = '@var';
        }
        return parent::parseTagValue($tokens, $tag);
    }
}
