<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Parser;

use PhpParser\Error;
use PhpParser\Node\Stmt;

class Result
{
    /** @var Stmt[] $statements */
    private $statements;

    /** @var Error[] $errors */
    private $errors;

    /**
     * Create container with parser result.
     *
     * @param Stmt[] $statements
     * @param Error[] $errors
     */
    public function __construct(array $statements, array $errors)
    {
        $this->statements = $statements;
        $this->errors = $errors;
    }

    /**
     * Get parsed statements
     *
     * @return Stmt[]
     */
    public function getStatements(): array
    {
        return $this->statements;
    }

    /**
     * Get parsing errors
     *
     * @return Error[]
     */
    public function getErrors(): array
    {
        return $this->errors;
    }
}
