<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php;

use Magento\Mray\CodeStructuralElement\FullQualifiedStructuralElementName;
use function sprintf;

abstract class PhpFqsen implements FullQualifiedStructuralElementName
{
    /**
     * @return string
     */
    public function domain(): string
    {
        return 'php';
    }

    /**
     * @return string
     */
    public function canonical(): string
    {
        return sprintf('mray:%s,%s', $this->domain(), $this->normalized());
    }

    /**
     * @return string
     */
    abstract public function normalized(): string;

    /**
     * @return string
     */
    public function __toString(): string
    {
        return $this->canonical();
    }
}
