<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\PhpFqsen;

use Magento\Mray\CodeStructuralElement\Php\PhpFqsen;
use function strtolower;

class ClassLike extends PhpFqsen
{
    /** @var string */
    private $classFqn;

    /**
     * @param string $classFqn
     */
    public function __construct(string $classFqn)
    {
        $this->classFqn = $classFqn;
    }

    /**
     * @return string
     */
    public function pretty(): string
    {
        return $this->classFqn;
    }

    /**
     * @return string
     */
    public function normalized(): string
    {
        return strtolower($this->classFqn);
    }
}
