<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\PhpFqsen;

use Magento\Mray\CodeStructuralElement\Php\PhpFqsen;
use function sprintf;
use function strtolower;

class ClassLikeMethod extends PhpFqsen
{
    /**
     * @var string
     */
    private $classFqn;
    /**
     * @var string
     */
    private $methodName;

    /**
     * @param string $classFqn
     * @param string $methodName
     */
    public function __construct(string $classFqn, string $methodName)
    {
        $this->classFqn = $classFqn;
        $this->methodName = $methodName;
    }

    /**
     * @return string
     */
    public function pretty(): string
    {
        return sprintf('%s::%s', $this->classFqn, $this->methodName);
    }

    /**
     * @return string
     */
    public function normalized(): string
    {
        return sprintf('%s::%s()', strtolower($this->classFqn), strtolower($this->methodName));
    }
}
