<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\PhpFqsen;

use Magento\Mray\CodeStructuralElement\Php\PhpFqsen;
use function sprintf;
use function strtolower;

class ClassLikeProperty extends PhpFqsen
{
    /**@var string */
    private $classFqn;
    /** @var string */
    private $propertyName;

    /**
     * @param string $classFqn
     * @param string $propertyName
     */
    public function __construct(string $classFqn, string $propertyName)
    {
        $this->classFqn = $classFqn;
        $this->propertyName = $propertyName;
    }

    /**
     * @return string
     */
    public function pretty(): string
    {
        return sprintf('%s::$%s', $this->classFqn, $this->propertyName);
    }

    /**
     * @return string
     */
    public function normalized(): string
    {
        return sprintf('%s::$%s', strtolower($this->classFqn), $this->propertyName);
    }
}
