<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\CallableDeclaration;

use Magento\Mray\CodeStructuralElement\Php\Reflection\FunctionDeclaration;
use PhpParser\Node;

class Function_ extends FunctionLike implements FunctionDeclaration
{
    /** @var Node\Stmt\Function_  */
    private $node;

    /**
     * @param Node\Stmt\Function_ $node
     */
    public function __construct(
        Node\Stmt\Function_ $node
    ) {
        $this->node = $node;
        parent::__construct($node);
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return (string)$this->node->name;
    }
}
