<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\CallableDeclaration;

use Magento\Mray\CodeStructuralElement\Php\Reflection\ParameterDeclaration;
use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;
use PHPStan\PhpDocParser\Ast\PhpDoc\MethodTagValueParameterNode;
use function ltrim;

class PhpDocMethodTagValueParameter implements ParameterDeclaration
{
    /** @var MethodTagValueParameterNode  */
    private $paramTag;

    /**
     * @param MethodTagValueParameterNode $paramTag
     */
    public function __construct(MethodTagValueParameterNode $paramTag)
    {
        $this->paramTag = $paramTag;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return ltrim($this->paramTag->parameterName, '$');
    }

    /**
     * @return Type
     */
    public function getType(): Type
    {
        $type = $this->getExpectedArgumentType();
        if ($this->isVariadic()) {
            $type = TypeFactory::get(Types\Array_::class, $type);
        }
        return $type;
    }

    /**
     * @return Type
     */
    public function getExpectedArgumentType(): Type
    {
        return TypeFactory::cast($this->paramTag->type);
    }

    /**
     * @return bool
     */
    public function isVariadic(): bool
    {
        return $this->paramTag->isVariadic;
    }

    /**
     * @return bool
     */
    public function isOptional(): bool
    {
        return isset($this->paramTag->defaultValue);
    }
}
