<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection;

interface ClassDeclaration extends ClassLikeDeclaration
{
    /**
     * @return string|null
     */
    public function getParentClass(): ?string;

    /**
     * @return array
     */
    public function getImplementedInterfaces(): array;

    /**
     * @return bool
     */
    public function isAbstract(): bool;

    /**
     * @return bool
     */
    public function isFinal(): bool;
}
