<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection;

interface ClassLikeDeclaration extends StructuralElementDeclaration
{
    /**
     * List class like from which members are inherited or copied.
     *
     * Implementation providers are other class like elements where members of this class like may be declared
     * (e.g. parent class, implemented interface or traits)
     *
     * @return string[]
     */
    public function getImplementationProviders(): array; // todo: handle circular dependencies

    /**
     * @return ClassLikeMemberDeclaration[]
     */
    public function getMembers(): array;
}
