<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\ClassLikeDeclaration;

use Magento\Mray\CodeStructuralElement\Php\Reflection\ClassDeclaration;
use Magento\Mray\CodeStructuralElement\Php\Reflection\Context\StructuralElementDeclarations;
use PhpParser\Node\Stmt;

class Class_ extends ClassLike implements ClassDeclaration
{
    /**
     * @var Stmt\Class_
     */
    private $node;

    /**
     * @param Stmt\Class_ $node
     * @param StructuralElementDeclarations|null $elementsRegistry
     */
    public function __construct(Stmt\Class_ $node, ?StructuralElementDeclarations $elementsRegistry = null)
    {
        $this->node = $node;
        parent::__construct($node, $elementsRegistry);
    }

    /**
     * @return string|null
     */
    public function getParentClass(): ?string
    {
        return $this->node->extends ? (string)$this->node->extends : null;
    }

    /**
     * @return array
     */
    public function getImplementedInterfaces(): array
    {
        $is = [];
        foreach ($this->node->implements as $i) {
            $is[] = (string)$i;
        }
        return $is;
    }

    /**
     * @return array
     */
    public function getImplementationProviders(): array
    {
        $implProviders = [];
        if ($this->getParentClass()) {
            $implProviders[] = $this->getParentClass();
        }
        foreach ($this->getImplementedInterfaces() as $impl) {
            $implProviders[] = $impl;
        }
        return $implProviders;
    }

    /**
     * @return Stmt\ClassLike
     */
    protected function getNode(): Stmt\ClassLike
    {
        return $this->node;
    }

    /**
     * @return bool
     */
    public function isAbstract(): bool
    {
        return $this->node->isAbstract();
    }

    /**
     * @return bool
     */
    public function isFinal(): bool
    {
        return $this->node->isFinal();
    }
}
