<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\ClassLikeDeclaration;

use Magento\Mray\CodeStructuralElement\Php\Reflection\ClassLikeMemberDeclaration;
use Magento\Mray\CodeStructuralElement\Php\Reflection\Context\StructuralElementDeclarations;

class Finder
{
    /**
     * @var StructuralElementDeclarations
     */
    private $registry;
    
    /**
     * @var string[]
     */
    private $implementationProviders;

    /**
     * @var string
     */
    private $memberInterface;

    /**
     * @param string $memberInterface
     * @param StructuralElementDeclarations $registry
     * @param array $implementationProviders
     */
    public function __construct(
        string $memberInterface,
        StructuralElementDeclarations $registry,
        array $implementationProviders
    ) {
        $this->memberInterface = $memberInterface;
        $this->registry = $registry;
        $this->implementationProviders = $implementationProviders;
    }

    /**
     * @param string $name
     * @return array
     */
    public function getInheritedDeclarations(string $name): array
    {
        $declarations = [];
        foreach ($this->implementationProviders as $implementationProvider) {
            foreach ($this->registry->findClassLike($implementationProvider) as $ipd) {
                foreach ($ipd->getMembers() as $declaration) {
                    /** @var ClassLikeMemberDeclaration $declaration */
                    if (!$declaration->isPrivate() &&
                        $declaration instanceof $this->memberInterface &&
                        $declaration->getName() === $name
                    ) {
                        $declarations[] = $declaration;
                    }
                }
            }
        }
        return $declarations;
    }
}
