<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\ClassLikeDeclaration;

use Magento\Mray\CodeStructuralElement\Php\Reflection\Context\StructuralElementDeclarations;
use Magento\Mray\CodeStructuralElement\Php\Reflection\InterfaceDeclaration;
use PhpParser\Node\Stmt;

class Interface_ extends ClassLike implements InterfaceDeclaration
{
    /** @var Stmt\Interface_  */
    private $node;

    /**
     * @param Stmt\Interface_ $node
     * @param StructuralElementDeclarations|null $elementsRegistry
     */
    public function __construct(Stmt\Interface_ $node, ?StructuralElementDeclarations $elementsRegistry = null)
    {
        $this->node = $node;
        parent::__construct($node, $elementsRegistry);
    }

    /**
     * @return array
     */
    public function getExtendedInterfaces(): array
    {
        $implProviders = [];
        foreach ($this->node->extends as $ext) {
            $implProviders[] = (string)$ext;
        }
        return $implProviders;
    }

    /**
     * @return array
     */
    public function getImplementationProviders(): array
    {
        return $this->getExtendedInterfaces();
    }

    /**
     * @return Stmt\ClassLike
     */
    protected function getNode(): Stmt\ClassLike
    {
        return $this->node;
    }
}
