<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\ClassLikeDeclaration;

use Magento\Mray\CodeStructuralElement\Php\Reflection\Context\StructuralElementDeclarations;
use Magento\Mray\CodeStructuralElement\Php\Reflection\TraitDeclaration;
use PhpParser\Node\Stmt;

class Trait_ extends ClassLike implements TraitDeclaration
{
    /** @var Stmt\Trait_  */
    private $node;

    /**
     * @param Stmt\Trait_ $node
     * @param StructuralElementDeclarations|null $elementsRegistry
     */
    public function __construct(Stmt\Trait_ $node, ?StructuralElementDeclarations $elementsRegistry = null)
    {
        $this->node = $node;
        parent::__construct($node, $elementsRegistry);
    }

    /**
     * @return array
     */
    public function getImplementationProviders(): array
    {
        return [];
    }

    /**
     * @return Stmt\ClassLike
     */
    protected function getNode(): Stmt\ClassLike
    {
        return $this->node;
    }
}
