<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection;

use phpDocumentor\Reflection\Type;

interface ClassLikeMemberDeclaration extends StructuralElementDeclaration
{
    /**
     * @return string|null
     */
    public function getClassLikeName(): ?string;

    /**
     * @return Type|null
     */
    public function getValueType(): ?Type;

    /**
     * @return bool
     */
    public function isPublic(): bool;

    /**
     * @return bool
     */
    public function isProtected(): bool;

    /**
     * @return bool
     */
    public function isPrivate(): bool;
}
