<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\Context;

use Magento\Mray\CodeStructuralElement\Php\Reflection\Context;

class ArrowFunction implements Context
{
    use VariableScope;

    /**
     * @var Context
     */
    private $outerContext;

    /**
     * @param Context $outerContext
     */
    public function __construct(Context $outerContext)
    {
        $this->outerContext = $outerContext;
        foreach ($this->outerContext->getVariables() as $var) {
            $this->variables[$var->getName()] = $var;
        }
    }

    /**
     * @return Global_
     */
    public function getGlobal(): Global_
    {
        return $this->outerContext->getGlobal();
    }
}
