<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\Context;

use Magento\Mray\CodeStructuralElement\Php\Reflection;
use Magento\Mray\CodeStructuralElement\Php\Reflection\Context;
use Magento\Mray\CodeStructuralElement\Php\Reflection\VariableDefinition;
use PhpParser\Node;

class ClassMethod implements Context
{
    use VariableScope;

    /** @var ClassLike  */
    private $class;

    /**
     * @param Node\Stmt\ClassMethod $node
     * @param ClassLike $class
     */
    public function __construct(Node\Stmt\ClassMethod $node, ClassLike $class)
    {
        $this->class = $class;
        $thisDefinitionFromClass = $class->getThisVariableDefinition();
        if (!$node->isStatic()) {
            $this->registerVariableDefinition(new Reflection\VariableDefinition\This_($thisDefinitionFromClass));
            foreach ($thisDefinitionFromClass->getPropertiesDefinition() as $propertyDefinition) {
                $this->registerVariableDefinition($propertyDefinition);
            }
        }

        $methodName = (string)$node->name;
        $elementsRegistry = $this->getGlobal()->getStructuralElementDeclarations();
        foreach ($elementsRegistry->findClassLike((string)$thisDefinitionFromClass->getType()) as $cl) {
            foreach ($cl->getMembers() as $member) {
                if ($member instanceof Reflection\MethodDeclaration && $member->getName() === $methodName) {
                    foreach ($member->getParams() as $param) {
                        $this->registerVariableDefinition(new VariableDefinition\DeclaredParam($param));
                    }
                }
            }
        }
    }

    /**
     * @return VariableDefinition\ThisPreDefinition
     */
    public function getThisVariableDefinition(): VariableDefinition\ThisPreDefinition
    {
        return $this->class->getThisVariableDefinition();
    }

    /**
     * @return Global_
     */
    public function getGlobal(): Global_
    {
        return $this->class->getGlobal();
    }
}
