<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\Context;

use Magento\Mray\CodeStructuralElement\Php\Reflection\Context;

class Function_ implements Context
{
    use VariableScope;

    /** @var Global_  */
    private $global;

    /**
     * @param Global_ $global
     */
    public function __construct(Global_ $global)
    {
        $this->global = $global;
    }

    /**
     * @return Global_
     */
    public function getGlobal(): Global_
    {
        return $this->global;
    }
}
