<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\Context;

use Magento\Mray\CodeStructuralElement\Php\Reflection;
use Magento\Mray\CodeStructuralElement\Php\Reflection\Context;

final class None implements Context
{
    /**
     * @return static
     */
    public static function instance(): self
    {
        static $instance;
        if (!isset($instance)) {
            $instance = new self();
        }
        return $instance;
    }

    /** @var Global_  */
    private $global;

    /**
     * @param Reflection\VariableDefinition $def
     * phpcs:disable Magento2.CodeAnalysis.EmptyBlock
     */
    public function registerVariableDefinition(Reflection\VariableDefinition $def): void
    {
    }

    /**
     * @param string $name
     * @return Reflection\Variable
     */
    public function getVariable(string $name): Reflection\Variable
    {
        return new Reflection\Variable(
            new Reflection\VariableDefinition\Unknown($name)
        );
    }

    /**
     * @return Global_
     */
    public function getGlobal(): Global_
    {
        if (!isset($this->global)) {
            $this->global = new Global_();
        }
        return $this->global;
    }

    /**
     * @inheritDoc
     */
    public function getVariables(): array
    {
        return [];
    }
}
