<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\Context;

use Magento\Mray\CodeStructuralElement\Php\Reflection;
use Magento\Mray\CodeStructuralElement\Php\Reflection\Context;

class Pointer implements Context
{
    /** @var Context */
    private $context;

    /**
     * @param Context $context
     */
    public function __construct(Context $context)
    {
        $this->context = $context;
    }

    /**
     * @return Context
     */
    public function value(): Context
    {
        return $this->context;
    }

    /**
     * @param Context $context
     * @return Context
     */
    public function switch(Context $context): Context
    {
        $oldValue = $this->value();
        $this->context = $context;
        return $oldValue;
    }

    /**
     * @param Reflection\VariableDefinition $def
     */
    public function registerVariableDefinition(Reflection\VariableDefinition $def): void
    {
        $this->context->registerVariableDefinition($def);
    }

    /**
     * @param string $name
     * @return Reflection\Variable
     */
    public function getVariable(string $name): Reflection\Variable
    {
        return $this->context->getVariable($name);
    }

    /**
     * @return Global_
     */
    public function getGlobal(): Global_
    {
        return $this->context->getGlobal();
    }

    /**
     * @inheritDoc
     */
    public function getVariables(): array
    {
        return $this->context->getVariables();
    }
}
