<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\Context;

use Magento\Mray\CodeStructuralElement\Php\Reflection\ClassLikeDeclaration;
use Magento\Mray\CodeStructuralElement\Php\Reflection\ClassLikeMemberDeclaration;
use Magento\Mray\CodeStructuralElement\Php\Reflection\FunctionDeclaration;
use Magento\Mray\CodeStructuralElement\Php\Reflection\GlobalConstantDeclaration;
use Magento\Mray\CodeStructuralElement\Php\Reflection\ConstantDeclaration;
use Magento\Mray\CodeStructuralElement\Php\Reflection\MethodDeclaration;
use Magento\Mray\CodeStructuralElement\Php\Reflection\PropertyDeclaration;
use Magento\Mray\CodeStructuralElement\Php\Reflection\Type\CodeDiscoveryDependentType;
use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;
use function array_map;
use function array_push;
use function array_unique;
use function array_values;
use function ltrim;
use function strtolower;

interface StructuralElementsKnowledgeBase
{
    /**
     * @param string $name
     * @return ClassLikeDeclaration[]
     */
    public function findClassLike(string $name): array;

    /**
     * @param string $name
     * @return FunctionDeclaration[]
     */
    public function findFunction(string $name): array;

    /**
     * @param string $name
     * @return GlobalConstantDeclaration[]
     */
    public function findGlobalConstant(string $name): array;
}
