<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection;

use PhpParser\Node;
use PHPStan\PhpDocParser\Ast\PhpDoc\PhpDocNode;

interface InCodeDeclaration extends StructuralElementDeclaration
{
    /**
     * @return Node[]
     */
    public function getDeclarationNodes(): array;

    /**
     * @return PhpDocNode|null
     */
    public function getPhpDoc(): ?PhpDocNode;
}
