<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection;

use phpDocumentor\Reflection\Type;

interface ParameterDeclaration
{
    /**
     * @return string|null
     */
    public function getName(): ?string;

    /**
     * @return Type
     */
    public function getType(): Type;

    /**
     * @return Type
     */
    public function getExpectedArgumentType(): Type;

    /**
     * @return bool
     */
    public function isVariadic(): bool;

    /**
     * @return bool
     */
    public function isOptional(): bool;
}
