<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\Type;

use Magento\Mray\CodeStructuralElement\Php\Reflection\ClassLikeMemberDeclaration;
use Magento\Mray\CodeStructuralElement\Php\Reflection\Context\StructuralElementDeclarations;
use Magento\Mray\CodeStructuralElement\Php\Reflection\TypeFactory;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;

class ClassLikeMemberValueType extends CodeDiscoveryDependentType
{
    /**
     * @var StructuralElementDeclarations
     */
    private $elementsRegistry;

    /**
     * @var Type
     */
    private $classLikeType;

    /**
     * @var string
     */
    private $elementType;

    /**
     * @var string
     */
    private $elementName;

    /**
     * @param StructuralElementDeclarations $elementsRegistry
     * @param Type $classLikeType
     * @param string $elementType
     * @param string $elementName
     */
    public function __construct(
        StructuralElementDeclarations $elementsRegistry,
        Type $classLikeType,
        string $elementType,
        string $elementName
    ) {
        $this->elementsRegistry = $elementsRegistry;
        $this->classLikeType = $classLikeType;
        $this->elementType = $elementType;
        $this->elementName = $elementName;
    }

    /**
     * @return Type
     */
    public function getClassLikeType(): Type
    {
        return $this->classLikeType;
    }

    /**
     * @return ClassLikeMemberDeclaration[]
     */
    public function getAccessedMembers()
    {
        return $this->elementsRegistry->estimateMembers(
            $this->classLikeType,
            $this->elementType,
            $this->elementName
        );
    }

    /**
     * @return Type
     */
    public function getEstimatedType(): Type
    {
        if ($this->cycle()) {
            return $this->estimated = TypeFactory::get(Types\Mixed_::class);
        }

        return $this->estimated = $this->elementsRegistry->estimateMemberValueType(
            $this->classLikeType,
            $this->elementType,
            $this->elementName
        );
    }

    /**
     * Return class member element name
     *
     * @return string
     */
    public function getElementName(): string
    {
        return $this->elementName;
    }
}
