<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\Type;

use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\Types;

abstract class CodeDiscoveryDependentType implements Type
{
    /**
     * @return Type
     */
    abstract public function getEstimatedType(): Type;

    /**
     * @return string
     */
    public function __toString(): string
    {
        return $this->getEstimatedType()->__toString();
    }

    /** @var Type|null */
    protected $estimated = null;

    /**
     * @return bool
     */
    protected function cycle(): bool
    {
        if (!$this->estimated) {
            return false;
        }

        return $this->isReferencedBy($this->estimated);
    }

    /**
     * @param Type $type
     * @return bool
     */
    protected function isReferencedBy(Type $type)
    {
        if ($type === $this) {
            return true;
        }
        if ($type instanceof FunctionReturnType) {
            return $this->isReferencedBy($type->estimated);
        } elseif ($type instanceof Types\AggregatedType) {
            foreach ($type->getIterator() as $tt) {
                if ($this->isReferencedBy($tt)) {
                    return true;
                }
            }
            return false;
        } elseif ($type instanceof Types\AbstractList) {
            return $this->isReferencedBy($type->getValueType()) || $this->isReferencedBy($type->getKeyType());
        }
        return false;
    }
}
