<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;

use Magento\Mray\CodeStructuralElement\Php\Reflection\ValueAccessor;
use Magento\Mray\CodeStructuralElement\Php\Reflection\ValuePointer;
use function array_map;

class KnownPath implements ValueAccessor
{
    /**
     * @var ValuePointer[]
     */
    private $path;

    /**
     * @param ValuePointer[] $path
     */
    public function __construct(array $path)
    {
        $this->path = array_map(function (ValuePointer $pointer) {
            return $pointer;
        }, array_values($path));
    }

    /**
     * @inheritDoc
     */
    public function getPath(): array
    {
        return $this->path;
    }

    /**
     * @return bool
     */
    public function resolvable(): bool
    {
        return !empty($this->getPath());
    }

    /**
     * @param ValueAccessor $other
     * @return bool
     */
    public function equal(ValueAccessor $other): bool
    {
        if (!$this->resolvable() || !$other->resolvable()) {
            return false;
        }

        $namesExtractor = function (ValuePointer $c) {
            return $c->getName();
        };
        $thisPath = array_map($namesExtractor, $this->getPath());
        $otherPath = array_map($namesExtractor, $other->getPath());
        return $thisPath === $otherPath;
    }
}
